unit fPatInq;
{ DATE CREATED:  9-99
  CREATED BY:    user   user, PORTLAND VAMC
  DESCRIPTION:   TABBED PATIENT INQUIRY WINDOW BASED ON APSB* PACKAGE AND
                 ACCESSIBLE BY CLICKING ON THE PATIENT NAME ON THE COVER SHEET
  MODIFIED:      2-18-00 }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ORCtrls, ORNet, uCore, Menus, ExtCtrls,
  fGenPrint, fRptBox, ORFn, rLocal;

type
  TfrmPtInq = class(TForm)
    tcPatInq: TTabControl;
    lstPatInq: TORListBox;
    Panel1: TPanel;
    btnPrint: TButton;
    btnCanc: TButton;
    reTemp: TRichEdit;
    lbTemp: TORListBox;
    procedure tcPatInqChange(Sender: TObject);
    procedure btnCancClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure lstPatInqClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPtInq: TfrmPtInq;

procedure PtInq;

implementation

{$R *.DFM}

uses SCMMain;

procedure PtInq;
var
  J: integer;
begin
  frmPtInq := TfrmPtInq.Create(Application);
  with frmPtInq do
    begin
      lstPatInq.Clear;
      tcPatInq.TabIndex := 0;
      CallV('APTWL GET PI', [DFN, tcPatInq.TabIndex]);
      lstPatInq.Items := RPCBrokerV.Results;
      J := tcPatInq.TabIndex;
      frmPtInq.Caption := 'Patient Inquiry - ' + tcPatInq.Tabs.Strings[J] + ' - ' + PtName;
      ShowModal;
    end;
  frmPtInq.Release;
end;

procedure TfrmPtInq.tcPatInqChange(Sender: TObject);
var
  J: integer;
begin
  lstPatInq.Clear;
  CallV('APTWL GET PI', [Patient.DFN, tcPatInq.TabIndex]);
  lstPatInq.Items := RPCBrokerV.Results;
  J := tcPatInq.TabIndex;
  frmPtInq.Caption := 'Patient Inquiry - ' + tcPatInq.Tabs.Strings[J] + ' - ' + PtName;
end;

procedure TfrmPtInq.btnCancClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPtInq.btnPrintClick(Sender: TObject);
var
  Title: string;
begin
  lbTemp.Items.Clear;
  lbTemp.Items[0] := tcPatInq.Tabs[tcPatInq.TabIndex];
  Title := frmPtInq.Caption;
  GenPrint(lstPatInq, Title, lstPatInq.Pieces, lstPatInq.TabPositions, lbTemp);
end;

procedure TfrmPtInq.lstPatInqClick(Sender: TObject);
begin
  if tcPatInq.TabIndex = 14 then
    begin
      ReportBox(DetailCall(Patient.DFN, piece(lstPatInq.Items[lstPatInq.ItemIndex], '^', 2)), 'TCP Call Detail - ' + PtName, False);
    end;
  if tcPatInq.TabIndex = 1 then
    begin
      ReportBox(DetailRx(Patient.DFN, piece(lstPatInq.Items[lstPatInq.ItemIndex], '^', 2)), 'Rx Detail - ' + PtName, False);
    end;
end;

end.
